//////////////////////////////////////////////
// Logger.js
//
//////////////////////////////////////////////

/// Class ------------------------------------
	
nkGraphicsTests.RenderContextManager = class RenderContextManager extends nkDebug.TestClass
{
	static instance = new RenderContextManager ("nkGraphicsTests.RenderContextManager") ;

	nkTests =
	{
		__testInit__ : function ()
		{
			// Init nkGraphics
			const s = nkGraphics.System.getInstance() ;

			const initResult = s.initialize() ;

			if (!initResult)
				console.log("Failure to initialize nkGraphics, bypassing Buffer test...")

			return initResult ;
		},
		__testShutdown__ : function ()
		{
			nkGraphics.System.getInstance().shutdown()  ;
			nkGraphics.System.kill() ;
		},

		EraseActiveWindowContextSafeFromWindowCall : function ()
		{
			// Create context and activate it
			const manager = nkGraphics.RenderContextManager.getInstance() ;
			const context = manager.createRenderContext(new nkGraphics.RenderContextDescriptor (32, 32, false)) ;
			manager.activateContext(context) ;
			nkDebug.TestUtils.check(context.$$.ptr == manager.getActiveRenderContext().$$.ptr, "Wrong activated context") ;

			// Erase, check active is switched
			const ptr = context.$$.ptr ;
			manager.eraseFor(context.getAttachedWin()) ;
			nkDebug.TestUtils.check(manager.getActiveRenderContext() == null || ptr != manager.getActiveRenderContext().$$.ptr, "Erased context not unset from active") ;
		},
		EraseActiveWindowContextSafeFromContextCall : function ()
		{
			// Create context and activate it
			const manager = nkGraphics.RenderContextManager.getInstance() ;
			const context = manager.createRenderContext(new nkGraphics.RenderContextDescriptor (32, 32, false)) ;
			manager.activateContext(context) ;
			nkDebug.TestUtils.check(context.$$.ptr == manager.getActiveRenderContext().$$.ptr, "Wrong activated context") ;

			// Erase, check active is switched
			const ptr = context.$$.ptr ;
			manager.erase(context) ;
			nkDebug.TestUtils.check(manager.getActiveRenderContext() == null || ptr != manager.getActiveRenderContext().$$.ptr, "Erased context not unset from active") ;
		},
		EraseActiveOffscreenContextSafe : function ()
		{
			// Create context and activate it
			const manager = nkGraphics.RenderContextManager.getInstance() ;
			const context = manager.createRenderContext(new nkGraphics.RenderContextDescriptor (32, 32, true)) ;
			manager.activateContext(context) ;
			nkDebug.TestUtils.check(context.$$.ptr == manager.getActiveRenderContext().$$.ptr, "Wrong activated context") ;

			// Erase, check active is switched
			const ptr = context.$$.ptr ;
			manager.erase(context) ;
			nkDebug.TestUtils.check(manager.getActiveRenderContext() == null || ptr != manager.getActiveRenderContext().$$.ptr, "Erased context not unset from active") ;
		},
	}
}